﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Oswiadczenia.aspx.cs" Inherits="ePaski.Oswiadczenia" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        $(function () {
            $(".divZakladka").corner("top 8px");
            $(".divPityZakladka").corner("top 8px");

            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-folder-open' } });

            $('#divPaskiZakladka').bind('click', function () {
                location = $('#aPaski').attr("href");
                return false;
            });

            $("[id$=divPityZakladka]").bind('click', function () {
                location = $('#aPity').attr("href");
                return false;
            });

            $('[id$=divDaneDoPitZakladka]').bind('click', function () {
                location = $('#aDaneDoPit').attr("href");
                return false;
            });
        });
    </script>
    <style type="text/css">
        .divZakladka, .divPityZakladka {
            z-index: 3;
            position: relative;
            float: left;
            padding-top: 1px;
            width: 100px;
            height: 17px;
            border-left-style: solid;
            border-right-style: solid;
            border-top-style: solid;
            border-width: 1px;
            border-color: white;
            text-align: center;
        }


        #divPaskiZakladka:hover {
            background-color: whitesmoke;
            cursor: pointer;
        }

        .divPityZakladka:hover {
            background-color: whitesmoke;
            cursor: pointer;
        }

        #divDaneDoPitZakladka:hover {
            background-color: whitesmoke;
            cursor: pointer;
        }

        .divZakladka a, .divPityZakladka a {
            text-decoration: none;
            color: black;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphZakladki" runat="server">
    <div id="divPaskiZakladka" class="divZakladka">
        <a id="aPaski" href="Paski.aspx">Paski</a>
    </div>
    <div id="divOswiadczeniaZakladka" class="divZakladka" style="background-color: white;">
        Oświadczenia
    </div>
    <div id="divPityZakladka" class="divPityZakladka" runat="server">
        <a id="aPity" href="Pity.aspx">Deklaracje PIT</a>
    </div>
    <div id="divDaneDoPitZakladka" class="divPityZakladka" runat="server">
        <a id="aDaneDoPit" href="DaneDoPit.aspx">Dane do PIT</a>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
    <div>
        <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label>
    </div>
    <div class="divPrzerwa20">
        &nbsp;
    </div>
    <div id="divFiltry">
        <span>Status </span>
        <asp:DropDownList ID="ddlStatus" runat="server">
            <asp:ListItem Value="" Selected="True">Wszystkie</asp:ListItem>
            <asp:ListItem Value="NRO">Do wypełnienia</asp:ListItem>
            <asp:ListItem Value="ZAT">Zatwierdzone</asp:ListItem>
        </asp:DropDownList>
        <asp:Button ID="btnOdswiez" runat="server" Text="Odśwież" OnClick="btnOdswiez_Click" />
    </div>
    <div id="divLista">
        <div class="divPrzerwa20">
            &nbsp;
        </div>
        <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
        <asp:GridView ID="gvLista" runat="server" AllowSorting="True" AutoGenerateColumns="False"
            DataKeyNames="IdOswiadczenia,IdOswiadczeniaPracownika,DataAktywnosciOd,DataAktywnosciDo,Status,StatusNazwa,NazwaOswiadczenia,Edycja"
            DataSourceID="odsLista"
            Width="100%" OnDataBound="gvLista_DataBound" OnRowCommand="gvLista_RowCommand">
            <AlternatingRowStyle CssClass="TableItemAlt" />
            <Columns>
                <asp:TemplateField ShowHeader="False">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Otwórz"></asp:LinkButton>
                    </ItemTemplate>
                    <ItemStyle VerticalAlign="Middle" Width="80px" />
                </asp:TemplateField>
                <asp:BoundField DataField="NazwaOswiadczenia" HeaderText="Nazwa oświadczenia" SortExpression="NazwaOswiadczenia" />
                <asp:BoundField DataField="DataAktywnosciOd" HeaderText="Aktywne od" SortExpression="DataAktywnosciOd" DataFormatString="{0:yyyy-MM-dd}" />
                <asp:BoundField DataField="DataAktywnosciDo" HeaderText="Aktywne do" SortExpression="DataAktywnosciDo" DataFormatString="{0:yyyy-MM-dd}" />
                <asp:BoundField DataField="StatusNazwa" HeaderText="Status" SortExpression="StatusNazwa" />
            </Columns>
            <HeaderStyle CssClass="TableHeader" />
            <RowStyle CssClass="TableItem" />
            <SelectedRowStyle CssClass="TableItemSelected" />
        </asp:GridView>
        <asp:ObjectDataSource ID="odsLista" runat="server" SelectMethod="PobierzWs" TypeName="iKPService.OswiadczeniaPracownika"
            SortParameterName="sort" OnSelected="odsLista_Selected">
            <SelectParameters>
                <asp:SessionParameter Name="idPracownika" SessionField="ID_PRACOWNIKA" Type="String" />
                <asp:SessionParameter Name="idFirmy" SessionField="ID_FIRMY" Type="String" />
                <asp:ControlParameter ControlID="ddlStatus" Name="status" PropertyName="SelectedValue" ConvertEmptyStringToNull="true"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="divPrzerwa20">
            &nbsp;
        </div>
    </div>
</asp:Content>
